
clear; clc; 
% DataFolderLocation = 'C:\Users\ipetrella\Dropbox\Skewness Project\Skewness Paper\Simulated method of moments files\Data';
DataFolderLocation = 'C:\Users\EMFIP\Dropbox\Skewness Project\Skewness Paper\Simulated method of moments files\Data'; 
CurrentFolder = cd; 
path(path,[CurrentFolder '\Subroutines']);

FONT_SIZE = 13; 
SPESSORE = 2;


[~,~,AnnualGrowth] = xlsread([CurrentFolder '\Data\SomeMacroSeries.xls'],'MACRO SERIES FRED','l4:o280'); AnnualGrowth = cell2mat(AnnualGrowth); 
[~,~,DatesNum] = xlsread([CurrentFolder '\Data\SomeMacroSeries.xls'],'MACRO SERIES FRED','b4:b280'); DatesNum = cell2mat(DatesNum);

DatesStr = datestr(DatesNum);
Dates = [1947+2/4:1/4:2020]'; Dates = Dates(1:size(DatesNum,1),1);

NamesVariables{1} = 'GDP Annual Growth'; 
NamesVariables{2} = 'Consumption Annual Growth'; 
NamesVariables{3} = 'Investment Annual Growth'; 

All_DATA = AnnualGrowth;

CUT_Initialization = 10*4; 
% StartingDate = find(Dates==1960+1/4)-CUT_Initialization;
StartingDate =1+4;
%% Trim Sample
All_DATA=All_DATA(StartingDate:end,:); 
Dates = Dates(StartingDate:end,:); 
DatesNum = DatesNum(StartingDate:end,:); 
DatesStr = DatesStr(StartingDate:end,:); 
%%

CUT_Sample_at84 = find(Dates==1984+2/4); 
% CUT_Sample_at84 = find(Dates==1984); 

for jj=1:size(All_DATA,2); 
    XX = All_DATA(:,jj);

    %% SKEWNESS 
    [TV_Skew,SD_TV_Skew]=TV_Skewness(XX,'Gaussian');
    vedi = [TV_Skew,SD_TV_Skew]; 
    
%     [TV_Skew,SD_TV_Skew]=TV_Skewness(XX,'Rolling');
    [TV_Skew,SD_TV_Skew]=TV_Skewness(XX,'EWMA');
    vedi2 = [TV_Skew,SD_TV_Skew]; 
    
    SaveTV_Skew(:,:,jj) = [vedi NaN*vedi(:,1) vedi2]; 
    
    %% VOLATILITY 
    [TV_Vol,SD_TV_Vol]=TV_Volatility(XX,'Gaussian');
    vedi = [TV_Vol,SD_TV_Vol]; 
    
%     [TV_Skew,SD_TV_Skew]=TV_Volatility(XX,'Rolling');
    [TV_Vol,SD_TV_Vol]=TV_Volatility(XX,'EWMA');
    vedi2 = [TV_Vol,SD_TV_Vol]; 
    
    SaveTV_Vol(:,:,jj) = [vedi NaN*vedi(:,1) vedi2]; 
end


TT = size(All_DATA,1);
OnesZeros = [[ones(CUT_Sample_at84-CUT_Initialization,1); zeros(TT-CUT_Sample_at84,1)]...
    [zeros(CUT_Sample_at84-CUT_Initialization,1); ones(TT-CUT_Sample_at84,1)]];

for jj=1:size(All_DATA,2); 
    
    %% SKEWNESS
    XX = All_DATA(CUT_Initialization+1:CUT_Sample_at84,jj);
    [Skew_pre84,SD_Skew_pre84]=SkewnessAndSD(XX);
    STORE_Skewness_cut84(jj,[1 2]) = [Skew_pre84,SD_Skew_pre84];
    XX = All_DATA(CUT_Sample_at84+1:end,jj);
    [Skew_post84,SD_Skew_post84]=SkewnessAndSD(XX);
    STORE_Skewness_cut84(jj,[4 5]) = [Skew_post84,SD_Skew_post84];
    SubsampleSkewness(:,:,jj) = (OnesZeros*[Skew_pre84; Skew_post84])*ones(1,3) + (OnesZeros*[SD_Skew_pre84; SD_Skew_post84])*[-1 0 1];
    
    %% VOLATILITY
    XX = All_DATA(CUT_Initialization+1:CUT_Sample_at84,jj);
    [Vol_pre84,SD_Vol_pre84]=VarianceAndSD(XX);
    STORE_Vol_cut84(jj,[1 2]) = [Vol_pre84,SD_Vol_pre84];
    XX = All_DATA(CUT_Sample_at84+1:end,jj);
    [Vol_post84,SD_Vol_post84]=VarianceAndSD(XX);
    STORE_Vol_cut84(jj,[4 5]) = [Vol_post84,SD_Vol_post84];
    SubsampleVol(:,:,jj) = (OnesZeros*[Vol_pre84; Vol_post84])*ones(1,3) + (OnesZeros*[SD_Vol_pre84; SD_Vol_post84])*[-1 0 1];
    
end


ChooseVariable = 1 ;
ChooseWeighting = 1;
CUT_INITIAL = CUT_Initialization;

if ChooseWeighting==1
    SkewToPlot = squeeze(SaveTV_Skew(CUT_INITIAL+1:end,1:2,ChooseVariable)); 
    SkewToPlot_Subsamples = squeeze(SubsampleSkewness(:,:,ChooseVariable)); 
    VolToPlot = squeeze(SaveTV_Vol(CUT_INITIAL+1:end,1:2,ChooseVariable)); 
    VolToPlot_Subsamples = squeeze(SubsampleVol(:,:,ChooseVariable)); 
elseif ChooseWeighting==2
    SkewToPlot = squeeze(SaveTV_Skew(CUT_INITIAL+1:end,4:5,ChooseVariable)); 
    SkewToPlot_Subsamples = squeeze(SubsampleSkewness(:,:,ChooseVariable)); 
    VolToPlot = squeeze(SaveTV_Vol(CUT_INITIAL+1:end,4:5,ChooseVariable)); 
    VolToPlot_Subsamples = squeeze(SubsampleVol(:,:,ChooseVariable)); 
end
DatesToPlot = DatesNum(CUT_INITIAL+1:end,1); 

%% 3 Figures Panel 
Panel3FiguresWithSubSample = figure(12200); 
for jj=2:3 
ChooseVariable = jj;%+4; 
ChooseWeighting = 1;

if ChooseWeighting==1
    SkewToPlot = squeeze(SaveTV_Skew(CUT_INITIAL+1:end,1:2,ChooseVariable)); 
    SkewToPlot_Subsamples = squeeze(SubsampleSkewness(:,:,ChooseVariable)); 
elseif ChooseWeighting==2
    SkewToPlot = squeeze(SaveTV_Skew(CUT_INITIAL+1:end,4:5,ChooseVariable)); 
    SkewToPlot_Subsamples = squeeze(SubsampleSkewness(:,:,ChooseVariable)); 
end
DatesToPlot = DatesNum(CUT_INITIAL+1:end,1); 
SP = DatesToPlot(CUT_Sample_at84-(CUT_INITIAL));

figure;
% subplot(1,3,jj-1)
hax=axes; 
plot1 = plot(DatesToPlot,[SkewToPlot(:,1)*ones(1,3)+SkewToPlot(:,2)*[-1 0 1] SkewToPlot(:,1)*0 SkewToPlot_Subsamples],'linewidth',SPESSORE,'color','g');     
set(plot1(1),'linestyle','--');    
set(plot1(3),'linestyle','--');    
set(plot1(4),'linewidth',3-2,'color',[0 0 0]);    
set(plot1(5),'linewidth',3-1,'color','b','linestyle','--');     
set(plot1(6),'linewidth',3-1,'color','b');    
set(plot1(7),'linewidth',3-1,'color','b','linestyle','--');     
xlim([min(DatesToPlot) max(DatesToPlot)]);
line([SP SP],get(hax,'YLim'),'Color','k','linewidth',SPESSORE+1);
title(NamesVariables{ChooseVariable},'fontsize',FONT_SIZE);
set(gca,'Xtick',DatesToPlot); datetick('x','yyyy','keepticks'); 
recessionplot; datetick('x','yyyy','keeplimits');
grid('on');
tightfig; 
end
% tightfig(Panel3FiguresWithSubSample); 
% % saveas(gcf,'Panel3FiguresWithSubSample.pdf');
% saveas(Panel3FiguresWithSubSample,['Panel3FiguresWithSubSample'],'tif')


%% Figures Skew/Volatility Panel 
Panel3FiguresWithSubSample = figure(12201); 

ChooseVariable = 1;%+4; 
ChooseWeighting = 1;

if ChooseWeighting==1
    SkewToPlot = squeeze(SaveTV_Skew(CUT_INITIAL+1:end,1:2,ChooseVariable)); 
    SkewToPlot_Subsamples = squeeze(SubsampleSkewness(:,:,ChooseVariable)); 
    VolToPlot = squeeze(SaveTV_Vol(CUT_INITIAL+1:end,1:2,ChooseVariable)); 
    VolToPlot_Subsamples = squeeze(SubsampleVol(:,:,ChooseVariable)); 
elseif ChooseWeighting==2
    SkewToPlot = squeeze(SaveTV_Skew(CUT_INITIAL+1:end,4:5,ChooseVariable)); 
    SkewToPlot_Subsamples = squeeze(SubsampleSkewness(:,:,ChooseVariable)); 
    VolToPlot = squeeze(SaveTV_Vol(CUT_INITIAL+1:end,4:5,ChooseVariable)); 
    VolToPlot_Subsamples = squeeze(SubsampleVol(:,:,ChooseVariable)); 
end
DatesToPlot = DatesNum(CUT_INITIAL+1:end,1); 

SP = DatesToPlot(CUT_Sample_at84-(CUT_INITIAL));

figure;
hax=axes; 
% subplot(1,2,1)
plot1 = plot(DatesToPlot,[VolToPlot(:,1)*ones(1,3)+VolToPlot(:,2)*[-1 0 1] VolToPlot(:,1)*0 VolToPlot_Subsamples],'linewidth',SPESSORE,'color','g');     
set(plot1(1),'linestyle','--');    
set(plot1(3),'linestyle','--');    
set(plot1(4),'linewidth',3-2,'color',[0 0 0]);    
set(plot1(5),'linewidth',3-1,'color','b','linestyle','--');     
set(plot1(6),'linewidth',3-1,'color','b');    
set(plot1(7),'linewidth',3-1,'color','b','linestyle','--');     
xlim([min(DatesToPlot) max(DatesToPlot)]);
line([SP SP],get(hax,'YLim'),'Color','k','linewidth',SPESSORE+1);
title('VOLATILITY','fontsize',FONT_SIZE);
set(gca,'Xtick',DatesToPlot); datetick('x','yyyy','keepticks'); 
recessionplot; datetick('x','yyyy','keeplimits');
grid('on');
tightfig



figure;
% subplot(1,2,2)
hax=axes; 
plot1 = plot(DatesToPlot,[SkewToPlot(:,1)*ones(1,3)+SkewToPlot(:,2)*[-1 0 1] SkewToPlot(:,1)*0 SkewToPlot_Subsamples],'linewidth',SPESSORE,'color','g');     
set(plot1(1),'linestyle','--');    
set(plot1(3),'linestyle','--');    
set(plot1(4),'linewidth',3-2,'color',[0 0 0]);    
set(plot1(5),'linewidth',3-1,'color','b','linestyle','--');     
set(plot1(6),'linewidth',3-1,'color','b');    
set(plot1(7),'linewidth',3-1,'color','b','linestyle','--');     
xlim([min(DatesToPlot) max(DatesToPlot)]);
line([SP SP],get(hax,'YLim'),'Color','k','linewidth',SPESSORE+1);
title('SKEWNESS','fontsize',FONT_SIZE);
set(gca,'Xtick',DatesToPlot); datetick('x','yyyy','keepticks'); 
recessionplot; datetick('x','yyyy','keeplimits');
grid('on');
tightfig

% tightfig(Panel2FiguresWithSubSample); 
% saveas(gcf,'Panel2FiguresWithSubSample.pdf');
% saveas(gcf,'Panel2FiguresWithSubSample','.tif');













